// testdrivecmd.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <sys/timeb.h>
#include <time.h>
#include <math.h>
#include <string.h>


void usage()
{
	printf( "usage: testdrive volumeletter\n"
			"  where volumeletter is the identifier of the\n"
			"  drive to be tested, e.g., to test removable drive\n"
			"  E:, use \"testdrive e\"\n\n" );
	exit(1);
}

#define ONE_MEGABYTE 0x100000

bool writeBuffer(FILE* af, TCHAR* buffer, ULONGLONG idx)
{
	size_t bytesIO;
	idx &= ONE_MEGABYTE - 1; 
	bytesIO = fwrite( buffer+idx, ONE_MEGABYTE - idx, 1, af);
	if (bytesIO < 1) {
		return false;
	}
	if (idx > 0) {
		bytesIO = fwrite( buffer, idx, 1, af);
		if (bytesIO < 1) {
			return false;
		}
	}
	return true;
}

bool chkBuffer(TCHAR* buffer, TCHAR* compBuffer, ULONGLONG idx)
{
	idx &= ONE_MEGABYTE - 1; 
	int compare_result = memcmp( buffer+idx, compBuffer, ONE_MEGABYTE - idx );
	if (compare_result) {
		return false;
	}
	if (idx > 0) {
		compare_result = memcmp( buffer, compBuffer+ONE_MEGABYTE-idx, idx );
		if (compare_result) {
			return false;
		}
	}
	return true;
}

FILE* openFile( ULONGLONG meg, char* mode, char vol )
{
	char fname[128];
	sprintf( fname, "%c:\\testdrive_%04x.dat", vol, meg >> 10 );
	printf( "\nOpening %s\n", fname );
	return fopen( fname, mode );
}

void deleteFile( ULONGLONG meg, char vol )
{
	char fname[128];
	sprintf( fname, "%c:\\testdrive_%04x.dat", vol, meg >> 10 );
	printf( "Deleting %s\n", fname );
	unlink(fname);
}

double transferRate( struct _timeb* aStart, struct _timeb* aFinish, ULONGLONG aMegs )
{
	time_t startSecs = aStart->time;
	time_t finishSecs = aFinish->time;
	return (aMegs * 1.0) / ((finishSecs - startSecs) * 1.0);
}

int transferRateClass( double aRate )
{
	return (int) floor(aRate);
}

int transferRateX( double aRate )
{
	return (int) floor(aRate * 6.5);
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc != 2) {
		usage();
	}

	bool success = false;
	ULARGE_INTEGER freeBytesAvailable;
	ULARGE_INTEGER totalNumberOfBytes;
	ULARGE_INTEGER totalNumberOfFreeBytes;
	DWORD reason;
	TCHAR vol[3] = "c:";
	vol[0] = argv[1][0];
	BOOL result = GetDiskFreeSpaceEx(
		vol, 
		&freeBytesAvailable,
		&totalNumberOfBytes,
		&totalNumberOfFreeBytes );
	if (!result) {
		reason = GetLastError();
		printf( "ERROR: Unable to get free disk space for %s.  Error code is 0x%x\n",
			vol, reason );
		exit(1);
	}
	ULONGLONG freeAvail = freeBytesAvailable.QuadPart;
	ULONGLONG megs2fill = freeAvail >> 20;
	TCHAR *fillBuffer = (TCHAR*) malloc(ONE_MEGABYTE);
	if (!fillBuffer) {
		printf( "ERROR: Unable to allocate enough memory for the fill buffer.\n" );
		exit(1);
	}
	TCHAR *pBuf;
	TCHAR *pEndBuf = fillBuffer + ONE_MEGABYTE;
	srand( (unsigned)time( NULL ) );
	for (pBuf = fillBuffer; pBuf < pEndBuf; ++pBuf) {
		*pBuf = rand();
	}
	TCHAR *compBuffer = (TCHAR*) malloc(ONE_MEGABYTE);
	if (!compBuffer) {
		printf( "ERROR: Unable to allocate enough memory for the compare buffer.\n" );
		exit(1);
	}
	printf( "Drive %s reports that it has %I64u megabytes free.  Filling it...\n", 
			vol, megs2fill );

	ULONGLONG meg;
	int megs_io;
	ULONGLONG gig_mask = 0x3ff;
	struct _timeb startTime, finishTime;

	size_t bytesIO;
	FILE *f = NULL;
	double rate;
	for (meg = 0, megs_io = 0; meg < megs2fill; ++meg, ++megs_io) {
		if ((meg & gig_mask) == 0) {
			if (f) {
				fflush(f);
				_ftime_s(&finishTime);
				rate = transferRate( &startTime, &finishTime, megs_io );
				int X = transferRateX(rate);
				int Class = transferRateClass(rate);
				printf( "Wrote %1d megs at %1.1lf mb/s (%1dX, class %1d)\n", 
						megs_io, rate, transferRateX(rate), transferRateClass(rate) );
				fclose(f);
				f = NULL;
			}
			f = openFile( meg, "wbc", vol[0] );
			if (!f) {
				reason = GetLastError();
				printf( "ERROR: Unable to create file.  Error code is 0x%x\n", reason );
				exit(1);
			}
			printf( "  Writing %6I64u of %6I64u\r", meg, megs2fill );
			megs_io = 0;
			_ftime_s(&startTime);
		}
		printf( "  Writing %6I64u\r", meg+1);
		if (!writeBuffer(f, fillBuffer, meg)) {
			reason = GetLastError();
			printf( "\n\nERROR: Unable to finish writing %6I64u.  Error code is 0x%x\n",
				meg, reason );
			exit(1);
		}
	}
	fflush(f);
	_ftime_s(&finishTime);
	rate = transferRate( &startTime, &finishTime, megs_io );
	printf( "Wrote %d megs at %1.1lf mb/s (%dX, class %d)\n", 
			megs_io, rate, transferRateX(rate), transferRateClass(rate) );
	fclose(f);
	f = NULL;
	printf("\n\nFinished writing...\n");
	success = true;

	for (meg = 0, megs_io = 0; meg < megs2fill; ++meg, ++megs_io) {
		if ((meg & gig_mask) == 0) {
			if (f) {
				_ftime_s(&finishTime);
				rate = transferRate( &startTime, &finishTime, megs_io );
				printf( "Read %d megs at %1.1lf mb/s\n", megs_io, rate);
				fclose(f);
				f = NULL;
			}
			f = openFile( meg, "rb", vol[0] );
			if (!f) {
				reason = GetLastError();
				printf( "ERROR: Unable to open file.  Error code is 0x%x\n", reason );
				exit(1);
			}
			printf( "  Reading %6I64u of %6I64u\r", meg, megs2fill );
			megs_io = 0;
			_ftime_s(&startTime);
		}
		printf( "  Reading %6I64u\r", meg+1 );
		//memset( compBuffer, 0, ONE_MEGABYTE );
		bytesIO = fread( compBuffer, ONE_MEGABYTE, 1, f );
		if (bytesIO < 1) {
			success = false;
			reason = GetLastError();
			printf( "\n\nERROR: Unable to finish reading %6I64u.  Error code is 0x%x\n",
				meg, reason );
			break;
		}
		if (!chkBuffer(fillBuffer,compBuffer,meg)) {
			success = false;
			printf( "\n\nERROR: Mismatch at %I64u megs (of %I64u).\n",
				meg+1, megs2fill );
			break;
		}
	}
	_ftime_s(&finishTime);
	rate = transferRate( &startTime, &finishTime, megs_io );
	printf( "Read %d megs at %1.1lf mb/s\n", megs_io, rate);
	fclose(f);

	for (meg = 0; meg < megs2fill; meg += 0x400) {
		deleteFile( meg, vol[0] );
	}
	free(fillBuffer);
	free(compBuffer);

	if (success) {
		printf( "\n\nDrive %s seems to be working properly!\n", vol );
		return 0;
	} else {
		printf( "\n\nSorry, but drive %s did not pass.\n", vol );
		return 1;
	}
}

